<?php
if  (realpath ($_SERVER['SCRIPT_FILENAME'])    ==    realpath (__FILE__))  { // avoid direct visiting...
	die ( 'Any man is liable to err, only a fool persists in error.' ); // sorry Cor, I like this quote better
}

class MyPajamas {
	var $_require_auth = true;
	var $_require_level = 0;
	var $_title = 'MyPajamas security';
	
	// set the authentication preferenes...
	var $_unique_id = 'demo'; // default value; you can run multiple logins at the same time by changing this id... 
	var $_session_time = 1800; // 30*60
	var $_code_location = './js/sha512.js';
	var $_recurring_hash_times = 10;

	// set the database connection preferences... just don't do it here ;)
	var $_sql_user = '';
	var $_sql_pass = '';
	var $_sql_database = '';
	var $_sql_table = '';
	
	
	function top() { // I handle the requested security type, and I return all the HTML/JS code produced below
		if($this->_require_auth && $this->auth_user() && $this->_require_level > 0) { // minimum user level (permissions) required
			if($this->get_permissions() >= $this->_require_level) {
				return $this->get_head() . $this->get_body_top();
			}
			else {
				echo $this->get_head() . $this->get_body_top() . '<h1>Permissions insufficient!</h1><p>You are not allowed to access this page...</p>' . $this->bottom();
				exit();
			}
		}
		elseif($this->_require_auth && !$this->auth_user()) { // identification required (permissions not bothered)
			echo $this->get_head() . $this->get_body_top() . '<h1>ID needed!</h1><p>You will have to identify yourself before I let you in...</p>' . $this->bottom();
			exit();
		}
		else { // anyone can enter
			return $this->get_head() . $this->get_body_top();
		}
	}
	
	function get_head() {
		$head = '
		<!DOCTYPE html>
		<head>
			<meta http-equiv="content-type" content="text/html;charset=utf-8"> 
			<meta http-equiv="cache-control" content="no-cache">
			<meta http-equiv="content-language" content="en-us">
			<meta name="copyright" content="MyPajamas">
			<meta name="keywords" content="DamnYankee security, demo, mypajamas, corz"> 
			<meta name="description" content="A secure website!"> 
			
			
			<!--This page was generated at; '.date('l jS M Y').' - Enjoy! -->
			<title>'.$this->_title.'</title>
			
			<style type="text/css"><!--
			@import url("css/style.css");
			//--></style>
			
			<!-- a nice show-off; give user ranks specific favicons (images on the left side of the url) -->
			<link rel="shortcut icon" href="./images/fav_' . $this->get_user_level() . '.ico" type="image/x-icon" />
			
			<script type="text/javascript" src="js/jquery-1.3.2.min.js"></script>
			<script type="text/javascript">
				/* Slider */
				$(document).ready(function() {
				$("#open").click(function(){ $("div#panel").slideDown("slow"); });	
				$("#close").click(function(){ $("div#panel").slideUp("slow"); });		
				$("#toggle a").click(function () { $("#toggle a").toggle(); });		
				});
			</script>';
		if(!$this->auth_user()) { $head .= $this->get_login_java(); }
		$head .= '
		</head>';
		
		return $head;
	}
	
	function get_body_top() {
		return '
		<body>
			<!-- Panel -->
			<div id="toppanel">
				<div id="panel">
					<div class="content clearfix">
					
						<div class="left">
							<h1>Welcome</h1>
							<h2>Scripts</h2>		
							<p class="grey">
								Blah, blah, blah... my site is super-duper-awesome.
							</p>
							<h2>&amp;more...</h2>
							<p class="grey">
								Demo text...
							</p>
							<p class="grey">
								<a href="http://corz.org/serv/security/pajamas.php" title="Pajamas origin">
									Visit Corz.org for the origin of this script! &raquo;
								</a>
							</p>
						</div>
						' . /* This is where the middle and right login thingies come; logging on, and registering? */
						$this->get_panel_bars()
						. '
					</div>
				</div> <!-- /login -->
					<!-- The tab on top -->	
				<div class="tab">
					<ul class="login">
						<li class="left">&nbsp;</li>
						<li>Hello ' . ucfirst($this->get_username(true)) . '</li>
						<li class="sep">|</li>
						<li id="toggle">
							<a id="open" class="open" href="#">Log In</a>
							<a id="close" style="display: none;" class="close" href="#">Close Panel</a>			
						</li>
						<li class="right">&nbsp;</li>
					</ul> 
				</div> <!-- / top -->
			</div> <!--panel -->
			
			<div id="page">
				';
	}
	
	function get_panel_bars() {
		if(!$this->auth_user()) { //$this->auth_user()
			return '
				<div class="left">
					<!-- Login Form Powered by DamnYankee Pajamas & JQuery -->
					<form 	class="clearfix" 
							method="post" 
							action="' . $this->get_self() . '"
							onsubmit="
								document.getElementById(\'auth_login_user\').value = hash(document.getElementById(\'auth_login_user\').value);
								document.getElementById(\'auth_login_pass\').value = hashpass(document.getElementById(\'auth_login_pass\').value);"
					>
						<h1>MyPajama login</h1>
						<label class="grey" for="auth_login_user">Username:</label>
						<input class="field" type="text" name="auth_login_user" id="auth_login_user" value="" size="23" />
						<label class="grey" for="auth_login_pass">Password:</label>
						<input class="field" type="password" name="auth_login_pass" id="auth_login_pass" size="23" />
						<!--<label>
							<input name="rememberme" id="rememberme" type="checkbox" checked="checked" value="forever" /> 
							&nbsp;Remember me
						</label>-->
						<div class="clear"></div>
						<input type="submit" name="submit" value="Login" class="bt_login" />
						<a class="lost-pwd" href="reset.php" style="display: block; float:left; clear: right; padding: 15px 5px 0; font-size: 0.95em; text-decoration: underline;">
							Lost your password?
						</a>
					</form>
				</div>
				<div class="left right">			
					<!-- Register Form -->
					<form action="#" method="post">
						<h1>Not a member yet? Sign Up!</h1>				
						<label class="grey" for="signup">Username:</label>
						<input class="field" type="text" name="signup" id="signup" value="" size="23" />
						<label class="grey" for="email">Email:</label>
						<input class="field" type="text" name="email" id="email" size="23" />
						<label>A password will be e-mailed to you.</label>
						<input type="submit" name="submit" value="Register" class="bt_register" />
					</form>
				</div>
				';
		}
		else {
			return '
			<div class="left">
					<h1>You are already logged on...</h1>
					<h2>Account information</h2>
					<table>
					<tr>
						<td>Username;</td>
						<td>' . $this->get_username() . '</td></tr>
					<tr>
						<td>Login-time;</td><td>	' . date('l j-m-Y H:i:s', $this->get_login_time()) . '</td>
					</tr>
					<tr>
						<td>Permission level;</td><td>	' . $this->get_permissions(). ' (' . ucfirst($this->get_user_level()) . '-rights)</td>
					</tr>
					<tr>
						<td colspan=2 ><a href="./edditaccount.php" title="Edit account!">Edit account &raquo;</a></td>
					</tr>
					<tr>
						<td colspan=2 >' . $this->get_logout_button() . '</td>
					</tr>
					</table>
				</div>
				<div class="left right">			
					<h1>same as the thingie to my left...</h1>
				</div>';
		}
	}
	
	function bottom() {
		return '	
			</div>
			
			<div style="height:25px;"></div> <!-- spacer -->
	
			<noscript>
				<div class="jcheckout">
					<div class="jcheck">
						<br />
						<p class="javaerror center">
							JavaScript...
						</p>
						<span class="center">
							<h3 style="color:#000;">
								Turn it ON please.
							</h3>
						</span>
						<br />&nbsp;
					</div>
				</div>
			</noscript>
		</body>';
	}
	
	/*
	
	From here, it's gonna be the *real* MyPajamas, all above was just creating a basic default site structure...
	
	*/
	function auth_user() { // check if the user is logged on; return true/false
	$this->get_session();
	
		if($_POST["logout"] === 'logout') { // user wants to log out
			$this->do_reset();
			if (!headers_sent()) { // This gets rid of the logout in the REQUEST vars
				header("Location: ".$this->get_self());
			}
			return false;
		}
		elseif($_POST["auth_login_pass"] != '') { // user wants to log in (and sent data)
			if( $this->check_ipau()  							// check if session is correct...
			&& $this->is_valid_sha($_POST["auth_login_user"]) 		// check wheter we've got valid hashes...
			&& $this->is_valid_sha($_POST["auth_login_pass"])) { 	// check wheter we've got valid hashes...

					$from_sql_pass = $this->get_passhash($_POST["auth_login_user"]);
					
					//echo "Retrieved from MySQL; $from_sql_pass <br />";
					$from_sql_pass = $this->get_hash($from_sql_pass . $this->get_rand_key());
					//echo "Calculated from MySQL; $from_sql_pass <br />";
					//print_r($_POST);
					//echo "rand; " . $this->get_rand_key();
					
					if($_POST["auth_login_pass"] === $from_sql_pass) {
						// set full session data...
						$this->fill_in_user_data($_POST["auth_login_user"]);
						$this->message = 'You succesfully logged on as ' . ucfirst($_SESSION['auth'.$this->_unique_id]['user']);
						return true;
					}
					else { // incorrect password!
						$this->message = 'Your log-in credentials were incorrect. Who be thou?';
						$this->do_reset();
						return false;
					}
			
			}
			else { // user sent invalid hashes or his ip/useragent happened to change (hijack alert!)
				$this->message = 'Your session contained invalid data. It will experience a reset. Apologies for the inconvienience.';
				$this->do_reset();
				return false;
			}
		}
		elseif($_SESSION['auth'.$this->_unique_id]['user']) { // user claims to be logged in
			if($this->check_ipau()) {
				// check if there session is correct !?
				if($this->timer()) { // logged on correctly
					$this->message = 'You are already correctly logged on as ' . ucfirst($_SESSION['auth'.$this->_unique_id]['user']);
					$this->get_logout_button();
					return true;
				}
				else { // Time out!
					$this->message = 'Your session has timed out.';
					$this->do_reset();
					return false;
				}
			}
			else {
				$this->message = 'Thou risk engendering ill will on the part of the humanoid mainspring of this place, by thou resided.';
				$this->do_reset();
				return false;
			}
		}
		else { // user has to start loggin in (show form)
			$this->message = 'You are not yet logged on... you haven\'t even tried yet!';
			return false;
		}
	}
	
	function get_passhash($user_to_find) { // beware; this baby searches the user HASH
		$link = mysql_connect('localhost', $this->_sql_user, $this->_sql_pass);
		if (!$link) { die('Could not connect: ' . mysql_error()); }
		mysql_select_db($this->_sql_database);
		
		$query = sprintf("SELECT `pass` FROM `%s` WHERE `userhash` LIKE '%s'",
			mysql_real_escape_string($this->_sql_table),
			mysql_real_escape_string($user_to_find));

		$result = mysql_query($query)  or die(mysql_error());
		$row = mysql_fetch_array($result);
		return $row['pass'];
		
		mysql_free_result($result);
		mysql_close($link);
	}

	function fill_in_user_data($user_to_find) { // user has been identified, now he gets his session variables; time (updates), id (used in sql), username and permissions
		$_SESSION['auth'.$this->_unique_id]['time'] = time();
		$_SESSION['auth'.$this->_unique_id]['login_time'] = time();

		
		$link = mysql_connect('localhost', $this->_sql_user, $this->_sql_pass);
		if (!$link) { die('Could not connect: ' . mysql_error()); }
		mysql_select_db($this->_sql_database);
		
		$query = sprintf("SELECT * FROM `%s` WHERE `userhash` LIKE '%s'",
			mysql_real_escape_string($this->_sql_table),
			mysql_real_escape_string($user_to_find)); // yes, double checked... delay is preferable to error.

		$result = mysql_query($query)  or die(mysql_error());
		$row = mysql_fetch_array($result);

		$_SESSION['auth'.$this->_unique_id]['id'] = $row['id'];
		$_SESSION['auth'.$this->_unique_id]['user'] = $row['user'];
		$_SESSION['auth'.$this->_unique_id]['permissions'] =  $row['pe'];
		// debug; echo $row['id'] . $row['user'] . $row['pe'];
		
		mysql_free_result($result);
		mysql_close($link);
	}
	
	function is_valid_sha($sha) { // checks wheter the provided string is an sha128 hash
		return !empty($sha) && preg_match('/^[a-f0-9]{128}$/', $sha);
	}

	function get_rand_key() { // return the salt used for this user, or create one for him. Ideally called twice for every login; once to provide a key (for the JS), and once to give the key as salt to PHP
		if ($_SESSION['auth'.$this->_unique_id]['key'] == '') {
			$_SESSION['auth'.$this->_unique_id]['key'] = $this->make_key();
		}
		return $_SESSION['auth'.$this->_unique_id]['key'];
	}
	
	function make_key() { // creates a key used by get_rand_key()
		$this->_random_string = '';
		for($i=0;$i<32;$i++) { 
			$this->_random_string .= chr(rand(97,122)); 
		} 
		return $this->_random_string;
	}

	function get_hash($input) { // make a hash... (recursive), ideally called once every login; upon validating
		for($i=0; $i <= $this->_recurring_hash_times; $i++) {
			$input = hash("sha512", $input);
		}
		return $input;
	}

	function get_session() { // creates first pieces of the session; remote ip-address and the user agent. Avoids hijacking...
		if (!headers_sent()) {
			session_start();
			header('Cache-control: private'); // IE 6 Fix
		}
		if($_SESSION['auth'.$this->_unique_id]['ip'] == '') {
			$_SESSION['auth'.$this->_unique_id]['ip'] = $_SERVER['REMOTE_ADDR'];
		}
		if($_SESSION['auth'.$this->_unique_id]['ua'] == '') {
			$_SESSION['auth'.$this->_unique_id]['ua'] = $_SERVER['HTTP_USER_AGENT'];
		}
	}
	
	function check_ipau() { // user visits again... but is it really him? check values set above (by get_session())
		if(	$_SESSION['auth'.$this->_unique_id]['ip'] == $_SERVER['REMOTE_ADDR']
		&& 	$_SESSION['auth'.$this->_unique_id]['ua'] == $_SERVER['HTTP_USER_AGENT']) {
			// session data is correct -> user did not "change" ip-address or user agent (aka; hijack is unlikely)
			return true;
		}
		else {
			return false;
		}
	}
	
	function timer() {
		if($_SESSION['auth'.$this->_unique_id]['time'] >= (time() - $this->_session_time)) {
			$_SESSION['auth'.$this->_unique_id]['time'] = time();
			return true;
		}
		else {
			return false;
		}
	}
	
	function do_reset() { // give the user a new session
		unset($_SESSION['auth'.$this->_unique_id]);
		$this->get_session();
	}
	
	function get_login_java() { // return encrypting javacode for form encryption
		return '
		<!-- Powered by DamnYankee -->
		<script type="text/javascript" src="'.$this->_code_location.'"></script>
		<script language="JavaScript">
		/* Username and password are hashed 100 times by default. 
		Server side-hashing of these happens only once (upon adding user to MySQL).
		Client side-hashing happens every attempted login.
		
		A salt is added to the password hash, after which is it hashed a custom amount of times.
		Both server and client do this every attempted login.
		*/
		function hashpass(input)  {
			var output = \'\';
			output = hash_custom(hash(input) +  \'' . $this->get_rand_key() . '\');
			return output;
		}
		
		function hash_custom(input) {
			for(i=0;i<=' . $this->_recurring_hash_times . ';i++) { 
				input = hex_sha512(input); 
			}
			return input;
		}
		
		function hash(input)  {
			for(i=0;i<=150;i++) { 
				input = hex_sha512(input); 
			}
			return input;
		}
		</script>';
	}
	
	// small functions
	function get_self() { // return url of script I was called by (not init.php)
		return $_SERVER['SCRIPT_NAME'];
	}
	
	function get_logout_button() { // return the html code used for a logout button
		return '<form name="logout_form" action="'.$this->get_self().'" method="post">
		<div class="auth-logout">
			<!-- Label_04 -->
			<input type="submit" value="logout" name="logout" />
		</div>
		</form>';

	}
	
	function get_id() {
		if(!isset($_SESSION)){
			session_start();
		}
		return $_SESSION['auth'.$this->_unique_id]['id'];
	}
	
	function get_username($guest=false) {
		if(!isset($_SESSION)){
			session_start();
		}
		if($guest && $_SESSION['auth'.$this->_unique_id]['user'] === null) {
			return 'guest';
		}
		return $_SESSION['auth'.$this->_unique_id]['user'];
	}
	
	function get_permissions() {
		if(!isset($_SESSION)){
			session_start();
		}
		return $_SESSION['auth'.$this->_unique_id]['permissions'];
	}
	
	function get_login_time() {
		if(!isset($_SESSION)){
			session_start();
		}
		return $_SESSION['auth'.$this->_unique_id]['login_time'];
	}
	
	function get_user_level() {
		//return $this->get_permissions();	$_SESSION['auth'.$this->_unique_id]['user']
		if($this->get_permissions() >= $this->_root) {
			return 'root';
		}
		elseif($this->get_permissions() >= $this->_admin) {
			return 'admin';
		}
		elseif($this->get_permissions() >= $this->_user) {
			return 'user';
		}
		else {
			return 'guest';
		}
	}
}
?>